/* ===============================
   MOBILE MENU TOGGLE
================================ */
const menuToggle = document.querySelector('.menu-toggle');
const nav = document.querySelector('.nav');

if (menuToggle && nav) {
  menuToggle.addEventListener('click', () => {
    nav.classList.toggle('show');
    menuToggle.setAttribute(
      'aria-expanded',
      nav.classList.contains('show')
    );
  });
}

/* ===============================
   CLOSE MENU ON LINK CLICK (MOBILE)
================================ */
document.querySelectorAll('.nav a').forEach(link => {
  link.addEventListener('click', () => {
    if (nav && nav.classList.contains('show')) {
      nav.classList.remove('show');
      menuToggle.setAttribute('aria-expanded', 'false');
    }
  });
});

/* ===============================
   FOOTER YEAR
================================ */
document.querySelectorAll('[id^="year"]').forEach(span => {
  span.textContent = new Date().getFullYear();
});

/* ===============================
   LIGHTBOX (GALLERY)
================================ */
const lightbox = document.getElementById('lightbox');
const lightboxImg = lightbox?.querySelector('.lightbox-img');
const lightboxClose = lightbox?.querySelector('.lightbox-close');

document.addEventListener('click', e => {
  const thumb = e.target.closest('.gallery-grid img');
  if (!thumb || !lightbox || !lightboxImg) return;

  lightboxImg.src = thumb.src;
  lightbox.classList.add('active');
  lightbox.setAttribute('aria-hidden', 'false');
});

lightboxClose?.addEventListener('click', () => {
  lightbox.classList.remove('active');
  lightbox.setAttribute('aria-hidden', 'true');
});

lightbox?.addEventListener('click', e => {
  if (e.target === lightbox) {
    lightbox.classList.remove('active');
    lightbox.setAttribute('aria-hidden', 'true');
  }
});

window.addEventListener('keydown', e => {
  if (e.key === 'Escape' && lightbox?.classList.contains('active')) {
    lightbox.classList.remove('active');
    lightbox.setAttribute('aria-hidden', 'true');
  }
});
